function [ hnd1 ] = plotDisparityMap2D( disparityMap, cellIdx )
% This function plots the sub-images generated by getDisparityMap2D.m

%--------------------------------------------------------------------------
%     Copyright (C) 2016 Michael Himpel (himpel@physik.uni-greifswald.de)
%
%     This program is free software: you can redistribute it and/or modify
%     it under the terms of the GNU General Public License as published by
%     the Free Software Foundation, either version 3 of the License, or
%     (at your option) any later version.
%
%     This program is distributed in the hope that it will be useful,
%     but WITHOUT ANY WARRANTY; without even the implied warranty of
%     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%     GNU General Public License for more details.
%
%     You should have received a copy of the GNU General Public License
%     along with this program.  If not, see <http://www.gnu.org/licenses/>.
%--------------------------------------------------------------------------

if nargin<2 || isempty(cellIdx)
    % no specific cells are given, so use all
    sets = {1:size(disparityMap,1), 1:size(disparityMap,2)};
    [x, y] = ndgrid(sets{:});
    cellIdx = [x(:) y(:)];
end

Nx = size(disparityMap,1);
Ny = size(disparityMap,2);
resSub = size(disparityMap,3);

% concatenate final images
final_image = zeros(Nx*resSub,Ny*resSub);  % +Nvox...to add line

hnd1 = figure; hold on;
for ind = cellIdx'
        final_image(ind(2)*resSub-(resSub-1):ind(2)*resSub, ind(1)*resSub-(resSub-1):ind(1)*resSub) = squeeze(disparityMap(ind(1), ind(2), :,:));
end

imagesc(final_image); axis tight;

% add grid:
[gX, gY] = meshgrid(1:resSub:Nx*resSub+1, 1:resSub:Ny*resSub+1);
plot(gX, gY,'-w', 'Linewidth',2);
plot(gX',gY','-w', 'Linewidth',2);

% indicate centres of each subMap
[cX, cY] = meshgrid((resSub+1)/2:resSub:Nx*resSub+1,(resSub+1)/2:resSub:Ny*resSub+1 );
plot(cX, cY,'ow', 'MarkerSize',10 );
plot(cX',cY','+w', 'Markersize',10);

if nargin >1
    % set limits to look only for the given cells
    minNx = min(cellIdx(:,1))*resSub-(resSub-1);
    maxNx = max(cellIdx(:,1))*resSub;
    minNy = min(cellIdx(:,2))*resSub-(resSub-1);
    maxNy = max(cellIdx(:,2))*resSub;
    %
    xlim([minNx maxNx]);
    ylim([minNy maxNy]);
end
end

