function [ trajectories ] = convertToTraj( tracks )
% This function converts the tracks that have been generated by
% track_particles to (my) usual "traj"-style 3d trajectories.

%--------------------------------------------------------------------------
%     Copyright (C) 2016 Michael Himpel (himpel@physik.uni-greifswald.de)
%     
%     This program is free software: you can redistribute it and/or modify
%     it under the terms of the GNU General Public License as published by
%     the Free Software Foundation, either version 3 of the License, or
%     (at your option) any later version.
% 
%     This program is distributed in the hope that it will be useful,
%     but WITHOUT ANY WARRANTY; without even the implied warranty of
%     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%     GNU General Public License for more details.
% 
%     You should have received a copy of the GNU General Public License
%     along with this program.  If not, see <http://www.gnu.org/licenses/>.
%--------------------------------------------------------------------------

trajectories = cell(1,length(tracks));
for k = 1:length(tracks)
    trajectories{k} = zeros(size(tracks(k).position,1),14);
    trajectories{k}(:,6) = tracks(k).frames;
    trajectories{k}(:,12:14) = tracks(k).position;
end


end

