function [trainingField] = generateTrainingFieldfromLookup(images, lookupTable)
% this function computes the training field from images and a loouptable
% containing the information on how to combine 4 pixels to one voxel.

% images must be input as TOBEDONE
images = reshape(images, size(images,1)*size(images,2), 4);
I1 = images(:,1);
I2 = images(:,2);
I3 = images(:,3);
I4 = images(:,4);

trainingField = (I1(lookupTable(:,1)) .* I2(lookupTable(:,2)) .* ...
                 I3(lookupTable(:,3)) .* I4(lookupTable(:,4)) ).^0.25;
end

