function [lookupTable] = generateTrainingFieldLookup(volGridpoints, P)
[XX, YY, ZZ] = ndgrid(volGridpoints.x , volGridpoints.y, volGridpoints.z);

trainingField = zeros(size(XX), 'single');
lookupTable = ones([numel(trainingField) 4], 'uint32');


for voxelCnt = 1:numel(trainingField)
    p2d_1 = P(1).projectionMatrix * [XX(voxelCnt); YY(voxelCnt); ZZ(voxelCnt) ; 1] ;
    p2d_1 = p2d_1(1:2)./p2d_1(3);
    p2d_1 = round(p2d_1);
    try
        lookupTable(voxelCnt, 1) = sub2ind([784, 1232], p2d_1(2), p2d_1(1)); 
    end
end

for voxelCnt = 1:numel(trainingField)
    p2d_1 = P(2).projectionMatrix * [XX(voxelCnt); YY(voxelCnt); ZZ(voxelCnt) ; 1] ;
    p2d_1 = p2d_1(1:2)./p2d_1(3);
    p2d_1 = round(p2d_1);
    try
        lookupTable(voxelCnt, 2) = sub2ind([784, 1232], p2d_1(2), p2d_1(1)); 
    end
end

for voxelCnt = 1:numel(trainingField)
    p2d_1 = P(3).projectionMatrix * [XX(voxelCnt); YY(voxelCnt); ZZ(voxelCnt) ; 1] ;
    p2d_1 = p2d_1(1:2)./p2d_1(3);
    p2d_1 = round(p2d_1);
    try
        lookupTable(voxelCnt, 3) = sub2ind([784, 1232], p2d_1(2), p2d_1(1));  
    end
end

for voxelCnt = 1:numel(trainingField)
    p2d_1 = P(4).projectionMatrix * [XX(voxelCnt); YY(voxelCnt); ZZ(voxelCnt) ; 1] ;
    p2d_1 = p2d_1(1:2)./p2d_1(3);
    p2d_1 = round(p2d_1);
    try
        lookupTable(voxelCnt, 4) = sub2ind([784, 1232], p2d_1(2), p2d_1(1)); 
    end
end

end

