function [field_initial, images, pos3d_gt ] = generateTrainingDatasets(volGridpoints, P, numImages, numParts, fileName)

% prepare indexing lookup table to speed up calculations
lookupTable = generateTrainingFieldLookup(volGridpoints, P);

for k = 1:numImages
        fprintf(1,'generating dataset no %d...\n', k);

	% use random particle positions to generate synthetic ground truth
        [field3d_gt, images, pos3d_gt] = generateArtificialField(numParts, volGridpoints, P);

        % use the ground truth images to get the initial field
        field_initial = generateTrainingFieldfromLookup(single(images)./255, lookupTable);
        
	% store as uint8 data (to make the dataset smaller)
        field_initial = uint8(field_initial.*255);

	% reshape to 3-dimensional field
	field_initial = reshape(field_initial, [length(volGridpoints.x), length(volGridpoints.y),...
					       length(volGridpoints.z) ]);
	if nargin == 5
	% save to disk
        save(sprintf(fileName, k), 'field3d_gt','images', 'field_initial', 'pos3d_gt');
	end
end
