function [field3d_gt, images, pos3d_collect] = generateArtificialField(numParts, volGridpoints, P)
%% preferences:

part2d_size = 0.0003;   % particle width in synthetic 2d images (smaller means larger)
part3d_size = 5;        % particle width in 3d gt-field (smaller means larger)

%TODO: image size preferences (here+network(

%% processing
[XX, YY, ZZ] = ndgrid(volGridpoints.x , volGridpoints.y, volGridpoints.z);


images = zeros(784, 1232, 4);
field3d_gt =  zeros( size(XX),'single');

x_max = max(volGridpoints.x);
x_min = min(volGridpoints.x);
y_max = max(volGridpoints.y);
y_min = min(volGridpoints.y);
z_max = max(volGridpoints.z);
z_min = min(volGridpoints.z);
genWindowSize = 5;

%pos2d_collect = cell(4);
if nargout==3
    pos3d_collect = zeros(numParts,3);
end
for k = 1:numParts
    pos3d = ([x_max-x_min ; y_max-y_min ; z_max-z_min] .* (rand(3,1)-0.5) ) + mean([x_max, x_min ; y_max, y_min ; z_max , z_min], 2);
    if nargout==3
        pos3d_collect(k,:) =  pos3d(1:3)';
    end

    intens_this = (0.6*rand+0.4);
    for camNo = 1:4
        pos2d = P(camNo).projectionMatrix * [pos3d ; 1];
        pos2d = pos2d./pos2d(3);
	
        %        pos2d_collect{camNo}(k,:) = pos2d(1:2)';
        window2d.xmin = round(pos2d(1))-genWindowSize;
        window2d.xmax = round(pos2d(1))+genWindowSize;
        window2d.ymin = round(pos2d(2))-genWindowSize;
        window2d.ymax = round(pos2d(2))+genWindowSize;
        idxY = window2d.ymin:window2d.ymax;
        idxX = window2d.xmin:window2d.xmax;
        
        [ X, Y ] = meshgrid(window2d.xmin:window2d.xmax, window2d.ymin:window2d.ymax);
        try
            images(idxY,idxX,camNo) = images(idxY,idxX,camNo) + intens_this * exp( -0.5* (( Y-pos2d(2)).^2 + (X-pos2d(1)).^2 )./part3d_size );
        end
    end
    
    gridIdx.xmin = find(abs(pos3d(1) - volGridpoints.x) == min(abs(pos3d(1) - volGridpoints.x)))-3;
    gridIdx.xmax = gridIdx.xmin +6;
    gridIdx.ymin = find(abs(pos3d(2) - volGridpoints.y) == min(abs(pos3d(2) - volGridpoints.y)))-3;
    gridIdx.ymax = gridIdx.ymin +6;
    gridIdx.zmin = find(abs(pos3d(3) - volGridpoints.z) == min(abs(pos3d(3) - volGridpoints.z)))-3;
    gridIdx.zmax = gridIdx.zmin +6;
    
    idxY = max(gridIdx.ymin, 1) : min(gridIdx.ymax, length(volGridpoints.y)) ;
    idxX = max(gridIdx.xmin, 1) : min(gridIdx.xmax, length(volGridpoints.x));
    idxZ = max(gridIdx.zmin, 1) : min(gridIdx.zmax, length(volGridpoints.z));
    
    try
        field3d_gt(idxX, idxY, idxZ ) = field3d_gt(idxX, idxY, idxZ ) + intens_this * exp(  -0.5*( (XX(idxX, idxY, idxZ)-pos3d(1)).^2  + (YY(idxX, idxY, idxZ)-pos3d(2)).^2  + (ZZ(idxX, idxY, idxZ)-pos3d(3)).^2 )./part2d_size  );
    end
end
field3d_gt = uint8(field3d_gt.*255 );
images = uint8(images.*255);

%
% p3d = getParticlesFromField(field3d_gt, volGridpoints, 30);
%
% plot3(pos3d_collect(:,1), pos3d_collect(:,2), pos3d_collect(:,3), '.'); hold on
% plot3(p3d(:,1), p3d(:,2), p3d(:,3), 'ro'); hold on
% figure;
%
% imshow(images(:,:,1)); hold on
% plot(pos2d_collect{1}(:,1), pos2d_collect{1}(:,2), 'ro')
% for k = 1:size(p3d,1)
%     pos2d = P(1).projectionMatrix * [p3d(k,:)' ; 1];
%     pos2d = pos2d./pos2d(3);
%     plot(pos2d(1), pos2d(2), 'co');
% end

end

