%% generate Training images
addpath('trainingFunctions');
load('projectionMatrix_example.mat');

%volume to cover for reconstruction, this has to match the geometry of the
%calibrated cameras!
volGridpoints.x = -7.54:0.044:7.04;
volGridpoints.y = -1.54:0.044:8.12;
volGridpoints.z = -2.2:0.04:0.5;

% set training dataset preferences
numImages = 1000;
numParticles = 4000;

mkdir training_images;
pathToImages = 'training_images/tr_%04d.mat'; %sprintf-readable mat-file location

generateTrainingDatasets(volGridpoints, P, numImages, numParticles, pathToImages );


%% training: from initial field to ground-truth field
addpath('networkFunctions');
network_savename = 'resultNetwork.mat';

trainParticleFieldNetwork; % look into script for further options


%% test the result: use the network to reconstruct positions from training data
% get a unknown dataset for testing
[~ , images, pos3d_gt ] = generateTrainingDatasets(volGridpoints, P, 1, 1000);
% convert to single data, as wanted by the network
images = single(images)./255;

% get the initial field
lookupTable = generateTrainingFieldLookup(volGridpoints, P);
field_initial = generateTrainingFieldfromLookup(images, lookupTable);
field_initial = reshape(field_initial, [length(volGridpoints.x), length(volGridpoints.y),...
    length(volGridpoints.z) ]);

% use the network to get the final field form the initial field
field_network = predict(trainedNetwork, field_initial);

% detect 3d particles in field and plot results
voxelThresh = 10;
distanceThresh = 0.1;

pos3d_result  = getParticlesFromField(field_network, volGridpoints, voxelThresh/255);

plot3(pos3d_gt(:,1), pos3d_gt(:,2), pos3d_gt(:,3), 'r.'); hold on
plot3(pos3d_result(:,1), pos3d_result(:,2), pos3d_result(:,3), 'bo');
axis equal
legend('ground truth', 'aipr');