%define own regression layer
classdef AIPR_RegressionLayer < nnet.layer.RegressionLayer
    % Example custom regression layer with mean-absolute-error loss.
    
    methods
        function layer = AIPR_RegressionLayer(name)
            % layer = maeRegressionLayer(name) creates a
            % mean-absolute-error regression layer and specifies the layer
            % name.
			
            % Set layer name.
            layer.Name = name;

            % Set layer description.
            layer.Description = 'Volumetric Product Loss';
        end
        
        function loss = forwardLoss(layer, Y, T)
            % loss = forwardLoss(layer, Y, T) returns the loss between
            % the predictions Y and the training targets T.

            % Calculate error according to AI-PR paper:
            
            % mult = T.*Y;
             %deno = T-Y; %error in the paper?
            % deno = T+Y;
            % loss =  1- sum(mult(:))/ (  sum(deno(:) + 1e-3));
            
            %dice loss across batch
             nom  = T.*Y;
             deno_T = T.^2;
             deno_Y = Y.^2;
             loss = 1 - (  2*sum(nom(:))  )/( sum(deno_T(:)) + sum(deno_Y(:)) );

        end
    end
end
