function [pos3d_vox] = getPositionsFromRegionprops(field3d, volGridpoints)

field3d = permute(field3d, [2 1 3]);

pos3d_vox = [];

for intensity_thresh = 0.7:-0.005:0.03
    out = regionprops3(field3d>intensity_thresh, field3d,  'WeightedCentroid', 'Volume', 'VoxelList');
    pos3d_vox = [pos3d_vox ; out.WeightedCentroid( out.Volume > 7   , :)];
    
    %field3d(permute(vertcat(out.VoxelList{out.Volume > 13}), [2 1 3])) = 0;
    if any(out.Volume > 7)
        for idx = find(out.Volume > 7)'
            
            indices = sub2ind(size(field3d), out.VoxelList{idx}(:,2), out.VoxelList{idx}(:,1), out.VoxelList{idx}(:,3));
            
            field3d(indices) = 0;
        end
    end
end

% convert to mm
pos3d_vox(:,1) =  (  pos3d_vox(:,1) -1  ) ./ (size(field3d,2) -1) .* ( volGridpoints.x(end)-volGridpoints.x(1) ) + volGridpoints.x(1);
pos3d_vox(:,2) =  (  pos3d_vox(:,2) -1  ) ./ (size(field3d,1) -1) .* ( volGridpoints.y(end)-volGridpoints.y(1) ) + volGridpoints.y(1);
pos3d_vox(:,3) =  (  pos3d_vox(:,3) -1  ) ./ (size(field3d,3) -1) .* ( volGridpoints.z(end)-volGridpoints.z(1) ) + volGridpoints.z(1);

end

