function [pos3d] = getParticlesFromField(field3d, volGridpoints, voxelThresh)
% find all particles using clustering
% find clusters
cutOffDist = 0.1; %cutoff-distance of cluster
idxAboveThresh = field3d>voxelThresh;

[XX, YY, ZZ] = ndgrid(volGridpoints.x , volGridpoints.y, volGridpoints.z);
% compute distance matrix, euclidean metric

positions = [reshape(XX(idxAboveThresh),[], 1) , reshape(YY(idxAboveThresh),[], 1), reshape(ZZ(idxAboveThresh),[], 1)];
intensities = [reshape(field3d(idxAboveThresh),[], 1) , reshape(field3d(idxAboveThresh),[], 1), reshape(field3d(idxAboveThresh),[], 1)];
intensities = single(intensities);

if isempty(positions)
    pos3d = [];
    return;
end

dist = pdist(positions,'euclid');
link = linkage(dist, 'single'); % the distance type may be varried...
clusteredIdx = cluster(link, 'cutoff', cutOffDist, 'criterion', 'distance');

%% determine position using weighted center of mass. The weights are the intensities of the basisFunctions
clusterNums = unique(clusteredIdx(:,1));

for k = reshape(clusterNums,1, [])
    idx = find(clusteredIdx == k);
    thisCluster     = positions(idx,:);
    thisIntensities = ones(size(thisCluster,1),3).*intensities(idx);
    pos3d(k,:) = 1./sum(thisIntensities,1) .* sum(thisIntensities.*thisCluster,1);
end

end

